// 
// Decompiled by Procyon v0.5.36
// 

package ORG.oclc.oai.harvester.catalog;

import ORG.oclc.oai.harvester.crosswalk.Crosswalk;
import ORG.oclc.oai.harvester.verb.Record;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import ORG.oclc.oai.harvester.verb.Identify;

public abstract class AbstractCatalog
{
    protected Identify identify;
    
    public void setIdentify(final Identify identify) {
        this.identify = identify;
    }
    
    protected Identify getIdentify() {
        return this.identify;
    }
    
    public static AbstractCatalog factory(final Properties properties) throws Throwable {
        AbstractCatalog oaiCatalog = null;
        final String oaiCatalogClassName = properties.getProperty("AbstractCatalog.oaiCatalogClassName");
        if (oaiCatalogClassName == null) {
            throw new ClassNotFoundException("AbstractCatalog.oaiCatalogClassName is missing from properties file");
        }
        final Class oaiCatalogClass = Class.forName(oaiCatalogClassName);
        final Constructor oaiCatalogConstructor = oaiCatalogClass.getConstructor(Properties.class);
        try {
            oaiCatalog = oaiCatalogConstructor.newInstance(properties);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        return oaiCatalog;
    }
    
    public abstract void delete(final String p0) throws IOException;
    
    public abstract void write(final Record p0, final String p1, final Crosswalk p2) throws IOException;
    
    public abstract void close();
}
